/* ut-demo1.c - basic example of using MicroThreads */
/* Jon Mayo - PUBLIC DOMAIN - August 23, 2005 */
#include <stdio.h>
#include "ut.h"

/* this thread keeps going until count is 5 */
unsigned example_th(struct ut_state *uts, int count) {
	printf("%s():enter. count=%d\n", __func__, count);
	UT_BEGIN(uts);
	printf("%s():This only done the first time. count=%d\n", __func__, count);
	UT_WAIT_WHILE(uts, count < 5);
	printf("%s():complete. count=%d\n", __func__, count);
	UT_END(uts);
}
int main(int argc, char **argv) {
	struct ut_state ex = UT_INITIALIZER;
	
	int count = 1;

	/* keep calling the thread's reentry until it returns non-zero */
	while(example_th(&ex, count)) {
		printf("%s():Looping...\n", __func__);
		count++;
	}
	
	return 0;
}
