/* ut.h - MicroThreads */
/* PUBLIC DOMAIN - Jon Mayo - Auguest 23, 2005 */
/* Version 1.0 */

#ifndef UT_H
#define UT_H

struct ut_state {
	unsigned line;
};

#define UT_STATUS_WAITING	        1
#define UT_STATUS_EXITED	        0
#define UT_BEGIN(uts)		        switch((uts)->line) { case 0:
#define UT_END(uts)		        } UT_EXIT(uts);
#define UT_INITIALIZE(uts)	        ((uts)->line=0)
#define UT_INITIALIZER		        {0}

/* sets the state, on reentry the program will continue at this point */
#define UT_SET(uts)	                (uts)->line=__LINE__; case __LINE__:

/* wait while condition cond is true */
#define UT_WAIT_WHILE(uts, cond)	do { UT_SET(uts); if((cond)) { return UT_STATUS_WAITING; } } while(0)

/* checks condition cond and continues if it's true */
#define UT_WAIT_UNTIL(uts, cond)	do { UT_SET(uts); if(!(cond)) { return UT_STATUS_WAITING; } } while(0)

/* restarts the state machine from the beginning */
#define UT_RESTART(uts)		        do { UT_INITIALIZE(uts); return UT_STATUS_WAITING; } while(0)

#define UT_EXIT(uts)		        do { UT_INITIALIZE(uts); return UT_STATUS_EXITED; } while(0)

/* use this for debugging, evalutes to the line number currently holding on */
#define UT_LINE(uts)		        ((uts)->line)

#endif
